// Kod uruchamiany po zaadowaniu strony
dojo.addOnLoad(function() {
    // Wywoanie funkcji search() po klikniciu przyciski 'go'
    dojo.event.connect(dojo.byId('go'), 'onclick', 'search');
});

function search() {
    // Jaka jest tre pola tekstowego?
    var q = dojo.byId('q').value;
    // Przesanie dania do serwera
    // Warto url powinna odpowiada stronie wyszukiwania
    dojo.io.bind({ 'url': '/search.php', 
                 'content': { 'q': q },
                 // Typ odpowiedzi
                 'mimetype': 'text/json',
                 // Funkcja wywoywana po odebraniu odpowiedzi
                 'load': showResults });
}

// Przetwarzanie wynikw
function showResults(type, results, evt) {
    var html = '';
    // Jeli s jakiekolwiek wyniki...
    if (results.length > 0) {
        html = '<ul>';
        // Utworzenie ich listy
        for (var i in results) {
            html += '<li>' + dojo.string.escapeXml(results[i]) + '</li>';
        }
        html += '</ul>';
    } else {
        html = 'Brak wynikw.';
    }
    // Umieszczenie wynikowego kodu HTML na stronie
    dojo.byId('output').innerHTML = html;
}
